/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.crusher;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.crusher.TileCrusher;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import com.lothrazar.cyclic.recipe.ingredient.RandomizedOutputIngredient;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeCrusher<TileEntityBase>
extends CyclicRecipe {
    private ItemStack result = ItemStack.f_41583_;
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    public final EnergyIngredient energy;
    public RandomizedOutputIngredient randOutput;
    public static final SerializeGenerateItem SERIALCRUSH = new SerializeGenerateItem();

    public RecipeCrusher(ResourceLocation id, Ingredient in, EnergyIngredient energy, ItemStack out, RandomizedOutputIngredient randOutput) {
        super(id);
        this.energy = energy;
        this.ingredients.add((Object)in);
        this.result = out;
        this.randOutput = randOutput;
    }

    public boolean matches(TileBlockEntityCyclic inv, Level worldIn) {
        try {
            TileCrusher tile = (TileCrusher)inv;
            return this.matches(tile.inputSlots.getStackInSlot(0), (Ingredient)this.ingredients.get(0));
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.f_43901_) {
            return current.m_41619_();
        }
        if (current.m_41619_()) {
            return ing == Ingredient.f_43901_;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public ItemStack m_8043_() {
        return this.result;
    }

    public RecipeType<?> m_6671_() {
        return CyclicRecipeType.CRUSHER;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALCRUSH;
    }

    public ItemStack createBonus(Random rand) {
        ItemStack getBonus = this.randOutput.bonus.m_41777_();
        if (this.randOutput.bonus.m_41613_() > 1) {
            getBonus.m_41764_(1 + rand.nextInt(this.randOutput.bonus.m_41613_()));
        }
        return getBonus;
    }

    public static class SerializeGenerateItem
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeCrusher<? extends TileBlockEntityCyclic>> {
        SerializeGenerateItem() {
            this.setRegistryName(new ResourceLocation("cyclic", "crusher"));
        }

        public RecipeCrusher<? extends TileBlockEntityCyclic> fromJson(ResourceLocation recipeId, JsonObject json) {
            try {
                Ingredient inputFirst = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
                ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
                RecipeCrusher r = new RecipeCrusher(recipeId, inputFirst, new EnergyIngredient(json), resultStack, new RandomizedOutputIngredient(json));
                return r;
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
                return null;
            }
        }

        public RecipeCrusher fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            RecipeCrusher r = new RecipeCrusher(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), new EnergyIngredient(buffer.readInt(), buffer.readInt()), buffer.m_130267_(), new RandomizedOutputIngredient(buffer.readInt(), buffer.m_130267_()));
            return r;
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeCrusher recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            zero.m_43923_(buffer);
            buffer.writeInt(recipe.energy.getRfPertick());
            buffer.writeInt(recipe.energy.getTicks());
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.randOutput.percent);
            buffer.m_130055_(recipe.randOutput.bonus);
        }
    }
}

